unit MAIN;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, FileCtrl, ComCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    StringGrid1: TStringGrid;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    DriveComboBox1: TDriveComboBox;
    Memo1: TMemo;
    Button1: TButton;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    StaticText1: TStaticText;
    CheckBox1: TCheckBox;
    procedure StringGrid1DblClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CheckBoxClick(Sender: TObject);
    procedure DriveComboBox1Change(Sender: TObject);
    procedure StringGrid1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);

  private
    { Private declarations }
    function FAttrDialog() : word;
  public
    { Public declarations }
    procedure ShowDir(RqDirFiles : string);
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// -------------------------------------------------------------------------
const AllFAttr  = $FF;       //     
                             //     
// -------------------------------------------------------------------------
var CurDir     : string;     //  
// -------------------------------------------------------------------------
//        
// -------------------------------------------------------------------------
//      
function FAttrToStr (RqAttr : word) : string;
var WStr : string;
begin
  WStr := '';
  if (RqAttr and faSymLink)   > 0 then WStr := '[LNK] ';
  if (RqAttr and faDirectory) > 0 then WStr := WStr + '[DIR] ';
  if (RqAttr and faVolumeID)  > 0 then WStr := WStr + '[VID] ';
  if (RqAttr and faSysFile)   > 0 then WStr := WStr + 'S';
  if (RqAttr and faHidden)    > 0 then WStr := WStr + 'H';
  if (RqAttr and faReadOnly)  > 0 then WStr := WStr + 'R';
  if (RqAttr and faArchive)   > 0 then WStr := WStr + 'A';
  if WStr = '' then WStr := '?';
  Result := WStr;
end;

//       
function ReShowDir(RqDir : string; RqFAttr : word; RqList : TStrings) : Cardinal;
var
  WDir   : string;
  sr     : TSearchRec;
begin
    WDir   := RqDir + '\*.*';
    Result := 0;
    if RqList = nil then Exit;
    if FindFirst(WDir, RqFAttr, sr) = 0 then
    begin
      repeat
        if (sr.Name <> '')
        then begin
          if (sr.Name <> '.') and (sr.Name <> '..')
          then begin
             if ((sr.Attr and faDirectory) > 0)
             then begin
                //  
                WDir := RqDir + '\' + sr.Name;
                ReShowDir(WDir, RqFAttr, RqList);
             end;
          end;
      end;
      until FindNext(sr) <> 0;
      FindClose(sr);
    end;
end;

//    
function TForm1.FAttrDialog() : word;
begin
  Result := 0;
  if CheckBox1.Checked then Result := faReadOnly;
  if CheckBox2.Checked then Result := Result or faHidden;
  if CheckBox3.Checked then Result := Result or faSysFile;
  if CheckBox4.Checked then Result := Result or faVolumeID;
  if CheckBox5.Checked then Result := Result or faDirectory;
  if CheckBox6.Checked then Result := Result or faArchive;
  if CheckBox7.Checked then Result := Result or AllFAttr; // faAnyFile;
end;

//   
procedure TForm1.ShowDir(RqDirFiles : string);
const TitArr : array [0..4] of string =
( '',' ','','',' ');
var   FileAttrs  : word;         //     
      sr         : TSearchRec;
      Ind        : integer;
begin
  StringGrid1.RowCount := 1;
  FileAttrs := FAttrDialog();

  with StringGrid1 do
  begin
    RowCount := 1;
    if FindFirst(RqDirFiles + '\*.*', FileAttrs, sr) = 0 then
    begin
      repeat
        sr.Attr := sr.Attr and $ff;
        if ((sr.Attr and FileAttrs) = sr.Attr) and (sr.Name <> '')
        then begin
          Ind := RowCount;
          RowCount := RowCount + 1;
          Cells[0,Ind] := IntToStr(Ind);
          Cells[1,Ind] := sr.Name;
          Cells[3,Ind] := IntToStr(sr.Size);
          Cells[4,Ind] := DateTimeToStr(FileDateToDateTime(sr.Time));

          if (sr.Attr and faDirectory) > 0
          then Objects [2, Ind] := Pointer($FFFF)
          else Objects [2, Ind] := nil;
          Cells[2,Ind] := FAttrToStr(sr.Attr);
        end;
      until FindNext(sr) <> 0;
      FindClose(sr);
    end;
    if RowCount < 2
    then begin
       RowCount := 2;
       for Ind := 0 to ColCount - 1 do Cells[Ind, 1] := '';
    end;
    FixedRows := 1;
    for Ind := 0 to ColCount - 1 do Cells[Ind, 0] := TitArr[Ind];
  end; // of with StringGrid1
end;

// -------------------------------------------------------------------------
//     
// -------------------------------------------------------------------------
//       
procedure TForm1.CheckBoxClick(Sender: TObject);
begin
  CurDir := GetCurrentDir();
  StaticText1.Caption := CurDir;
  ShowDir(CurDir);
end;

//   
procedure TForm1.StringGrid1DblClick(Sender: TObject);
begin
  with StringGrid1 do
  begin
     if Objects [2, Row] <> nil
     then begin
        ChDir(Cells[1,Row]);
        CurDir := GetCurrentDir;
        StaticText1.Caption := CurDir;
        ShowDir(CurDir);
     end;
  end;
end;

//   
procedure TForm1.DriveComboBox1Change(Sender: TObject);
var Disk : char;
begin
  Disk := DriveComboBox1.Drive;
  SetCurrentDir (Disk + ':');
  SetCurrentDir (Disk + ':\');
  CurDir := Disk + ':\';
  StaticText1.Caption := CurDir;
  ShowDir(CurDir);
end;

//   
procedure TForm1.FormCreate(Sender: TObject);
begin
  CurDir := GetCurrentDir();
  ShowDir(CurDir);
end;

//    
procedure TForm1.StringGrid1Click(Sender: TObject);
var WStr : string;
begin
    if StringGrid1.Cells[3, StringGrid1.Row] <> '0'
    then begin
      WStr := StringGrid1.Cells[1, StringGrid1.Row];
      if CurDir[Length(CurDir)] = '\'
      then WStr := CurDir + WStr
      else WStr := CurDir + '\' + WStr;
      Memo1.Lines.Add(Wstr);
    end;
end;

//  
procedure TForm1.Button1Click(Sender: TObject);
begin
   Memo1.Clear;
end;

end.
